<?php
    /*
     *
     * copyright (c) 2013-2023 Heliac Technologies
     * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
     *
     * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom

     * questo file mostra i commenti in una tabella. viene usato nella home page e nella pagina commenti
    */
?>
<div id="menu-componenti" class="modal fade" tabindex="-1" aria-labelledby="aggiungi un componente" aria-hidden="true" role="dialog">
    <div class="modal-dialog modal-xl" role="document">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Componenti</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body py-1">
                <?php 
                    if($_SESSION["geecomAdmin_ruolo"]!="autore") {
                        echo"<div class=\"row\">";
                        $queryComponenti = "SELECT * FROM geecD_componenti WHERE tipo LIKE 'esterno' OR tipo LIKE 'integrato' OR tipo LIKE 'pagine' OR tipo LIKE 'componenteDinamicoPagine' ORDER BY nome ASC ";
                        $risComponenti = $geecomDb->eseguiQueryLettura($queryComponenti);
                        while($componente = $risComponenti->fetch_assoc()) {
                            echo"<div class=\"col-6 col-sm-4 col-lg-3 col-xl-1 p-1 mb-1\">
                                <a href=\"$percorsoBase"."componenti/{$componente["paginaGestione"]}\" class=\"btn btn-light btn-block\">"
                                . "<img class=\"img-fluid\" src=\"$percorsoBase"."{$componente["icona"]}\">"
                                . "<h6>{$componente["nome"]}</h6>
                                </a>
                            </div>";
                        }
                        echo"</div>";
                    }
                    else {
                        ?>
                        <div class="text-center p-3">
                            Non disponi dei permessi per visualizzare la lista dei componenti
                        </div>
                        <?php
                    }
                ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Chiudi</button>
            </div>
        </div>
    </div>
</div>